<?php

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

defined( '_JEXEC' ) or die;

/**
 * Class HoneysuckleHelper
 */
class HoneysuckleHelper
{
	/**
	 * Добавление подменю
	 * @param String $vName
	 */
	static function addSubmenu( $vName )
	{
        JHtmlSidebar::addEntry(
            JText::_( 'COM_HONEYSUCKLE_LOGS' ),
            'index.php?option=com_honeysuckle&view=logs',
            $vName == 'logs' );
		JHtmlSidebar::addEntry(
			JText::_( 'COM_HONEYSUCKLE_IPS' ),
			'index.php?option=com_honeysuckle&view=spams',
			$vName == 'spams' );

        JHtmlSidebar::addEntry(
            JText::_( 'COM_HONEYSUCKLE_STOP_WORDS' ),
            'index.php?option=com_honeysuckle&view=stop_words',
            $vName == 'stop_words' );
	}

    public static function loadAssets() {

        $filemtime = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'administrator/components/com_honeysuckle/assets/css/honeysuckle.css');
        $filemtime_script = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'administrator/components/com_honeysuckle/assets/scripts/admin.js');
        $document = Factory::getDocument();
        $document->addStyleSheet(Uri::root().'administrator/components/com_honeysuckle/assets/css/honeysuckle.css?v='.$filemtime);
        $document->addScript(Uri::root().'administrator/components/com_honeysuckle/assets/scripts/admin.js?v='.$filemtime_script);
    }

    public static function showDonat() {
        $donat = '
<div id="supportTheAuthorBlock">
    <div class="row-fluid">
        <div class="span6">
            <h4>' . Text::_('COM_HONEYSUCKLE_YOUR_LIKE_COMPONENT') . '</h4><p>' . Text::_('COM_HONEYSUCKLE_SUPPORT_AUTHOR') . '</p>
        </div>
        <div class="span6">
            <a href="https://sitogon.ru/donats/podderzhka-razvitiya-komponenta-zhimolost" class="btn btn-danger btn-support" target="_blank">
                ' . Text::_('COM_HONEYSUCKLE_DONAT') . '
            </a>
        </div>
    </div>
</div>';

        return $donat;
    }

	/**
	 * Получаем доступные действия для текущего пользователя
	 * @return JObject
	 */
	public static function getActions()
	{
		$user = JFactory::getUser();
		$result = new JObject;
		$assetName = 'com_honeysuckle';
		$actions = JAccess::getActions( $assetName );
		foreach ( $actions as $action ) {
			$result->set( $action->name, $user->authorise( $action->name, $assetName ) );
		}
		return $result;
	}
}