<?php
/**
 * @copyright	Copyright (c) 2023 zamena. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// no direct access
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

/**
 * system - zamena Plugin
 *
 * @package		Joomla.Plugin
 * @subpakage	zamena.zamena
 */
class plgsystemzamena extends JPlugin {

	/**
	 * Constructor.
	 *
	 * @param 	$subject
	 * @param	array $config
	 */
	function __construct(&$subject, $config = array()) {
		// call parent constructor
		parent::__construct($subject, $config);
	}

    function onAfterRender(){
        $app = Factory::getApplication();

        if ($app->isClient('administrator')) {
            return;
        }

        $replaces = $this->getReplaces();

        if (is_array($replaces)) {
            if (count($replaces)) {
                $body = $app->getBody();

                foreach ($replaces as $replace) {
                    $body = str_replace($replace->old, $replace->new, $body);
                }

                $app->setBody($body);
            }
        }


    }


    private function getReplaces() {
        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db
            ->getQuery(true)
            ->select('old, new')
            ->from($db->quoteName('#__zamena_replaces'))
            ->where($db->quoteName('state') . " = 1" )
        ;

        $db->setQuery($query);
        $result = $db->loadObjectList();

        return $result;
    }
}