<?php
/**
 * @version    2.3.1
 * @package    Com_J_sms_registration
 * @author     Владимир Егоров <mail@sitogon.ru>
 * @copyright  2025 Vladimir Egorov
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Application\AdministratorApplication;
use Joomla\CMS\Cache\Cache;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Helper\LibraryHelper;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\Database\DatabaseDriver;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\CMS\Version;
use Joomla\Filesystem\Folder;
use Joomla\Filesystem\Path;
use Joomla\Registry\Registry;

return new class () implements ServiceProviderInterface {

    public function register(Container $container)
    {
        $container->set(InstallerScriptInterface::class, new class ($container->get(AdministratorApplication::class)) implements InstallerScriptInterface {

            public $release;

            /**
             * The application object
             *
             * @var  AdministratorApplication
             *
             * @since  1.0.0
             */
            protected AdministratorApplication $app;

            /**
             * The Database object.
             *
             * @var   DatabaseDriver
             *
             * @since  1.0.0
             */
            protected DatabaseDriver $db;

            /**
             * Minimum Joomla version required to install the extension.
             *
             * @var  string
             *
             * @since  1.0.0
             */
            protected string $minimumJoomla = '4.2.7';

            /**
             * Minimum PHP version required to install the extension.
             *
             * @var  string
             *
             * @since  1.0.0
             */
            protected string $minimumPhp = '7.4';

            /**
             * Constructor.
             *
             * @param   AdministratorApplication  $app  The application object.
             *
             * @since 1.0.0
             */
            public function __construct(AdministratorApplication $app)
            {
                $this->app = $app;
                $this->db  = Factory::getContainer()->get('DatabaseDriver');
            }

            /**
             * This method is called after a component is installed.
             *
             * @param   \stdClass  $installer  - Parent object calling this method.
             *
             * @return void
             */
            public function install(InstallerAdapter $adapter): bool
            {

                return true;

            }

            /**
             * Function called after the extension is uninstalled.
             *
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function uninstall(InstallerAdapter $adapter): bool
            {
                return true;
            }

            /**
             * Function called after the extension is updated.
             *
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function update(InstallerAdapter $adapter): bool
            {

                return true;

            }

            /**
             * Function called before extension installation/update/removal procedure commences.
             *
             * @param   string            $type     The type of change (install or discover_install, update, uninstall)
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function preflight(string $type, InstallerAdapter $adapter): bool
            {
                $this->release = $adapter->getParent()->get( "manifest" )->version;
                return true;

            }


            /**
             * Function called after extension installation/update/removal procedure commences.
             *
             * @param   string            $type     The type of change (install or discover_install, update, uninstall)
             * @param   InstallerAdapter  $adapter  The adapter calling this method
             *
             * @return  boolean  True on success
             *
             * @since   1.0.0
             */
            public function postflight(string $type, InstallerAdapter $adapter): bool
            {
                if ($type == 'install' || $type == 'update') {
                    $app = Factory::getApplication();
                    $lang = $app->getLanguage();
                    $lang->load('com_honeysuckle');
                    echo '<h3>' . Text::_('COM_HONEYSUCKLE') . '</h3>';
                    echo '<p>' . Text::_('COM_HONEYSUCKLE_XML_DESCRIPTION') . '</p>';
                    echo '<p>' . Text::sprintf('COM_HONEYSUCKLE_VERSION', $this->release) . '</p>';
                    echo '<p>' . Text::_('COM_HONEYSUCKLE_DEV') . '</p>';
                }

                if ($type == 'update' || $type == 'install') {
                    $this->deleteCatalogs();
                }


                return true;
            }

            public function deleteCatalogs() {
                if ( (int)JVERSION == 6) {
                    $folders = array();
                    $folders[] = JPATH_ROOT.DIRECTORY_SEPARATOR.'components/com_honeysuckle/src/Dispatcher/';

                    foreach ($folders as $folder) {
                        if (is_dir($folder)) {
                            $this->removeCatalog($folder);
                        }
                    }
                }
            }

            public function removeCatalog($dir)
            {
                if ($objs = glob($dir . '/*')) {
                    foreach ($objs as $obj) {
                        is_dir($obj) ? $this->removeCatalog($obj) : unlink($obj);
                    }
                }
                rmdir($dir);
            }

        });
    }
}; ?>
