<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Migation_instruments
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2023 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Categories\CategoryFactoryInterface;
use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\CategoryFactory;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Migrationinstruments\Component\Migation_instruments\Administrator\Extension\Migation_instrumentsComponent;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;


/**
 * The Migation_instruments service provider.
 *
 * @since  1.0.0
 */
return new class implements ServiceProviderInterface
{
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function register(Container $container)
	{

		$container->registerServiceProvider(new CategoryFactory('\\Migrationinstruments\\Component\\Migation_instruments'));
		$container->registerServiceProvider(new MVCFactory('\\Migrationinstruments\\Component\\Migation_instruments'));
		$container->registerServiceProvider(new ComponentDispatcherFactory('\\Migrationinstruments\\Component\\Migation_instruments'));
		$container->registerServiceProvider(new RouterFactory('\\Migrationinstruments\\Component\\Migation_instruments'));

		$container->set(
			ComponentInterface::class,
			function (Container $container)
			{
				$component = new Migation_instrumentsComponent($container->get(ComponentDispatcherFactoryInterface::class));

				$component->setRegistry($container->get(Registry::class));
				$component->setMVCFactory($container->get(MVCFactoryInterface::class));
				$component->setCategoryFactory($container->get(CategoryFactoryInterface::class));
				$component->setRouterFactory($container->get(RouterFactoryInterface::class));

				return $component;
			}
		);
	}
};
