<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Backcall
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Backcall\Component\Backcall\Site\Controller;

\defined('_JEXEC') or die;

use Backcall\Component\Backcall\Site\Helper\MainHelper;
use \Joomla\CMS\Application\SiteApplication;
use \Joomla\CMS\Factory;

use Joomla\CMS\Filesystem\Folder;
use \Joomla\CMS\Language\Multilanguage;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Controller\BaseController;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;
use \Joomla\Utilities\ArrayHelper;
use stdClass;

require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'components/com_backcall/src/Helper/telegram.php';
/**
 * Call class.
 *
 * @since  1.6.0
 */
class CallController extends BaseController
{

    public function send()
    {
        $app = Factory::getApplication();
        $input = $app->getInput();
        $object = new stdClass();

        $checkSpamOborona = $this->checkSpamOborona();

        if ($checkSpamOborona) {
            require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
            $spamParams = $checkSpamOborona->params;
            $Spam_OboronaMain = new \HoneysuckleMain($spamParams);

            $spamParams = new Registry($spamParams);
            $field_name = $spamParams->get('session_name_field', '');

            if ($field_name) {
                $check = $input->get($field_name, 0);
                if(!$check) {

                    $ip = $Spam_OboronaMain->getUserIpAddr();
                    $Spam_OboronaMain->addToSpam($ip, print_r($_REQUEST, true));
                    die('You Spam Bot!');
                }

            }
        }

        $model = $this->getModel('Call');

        $module_id = $_POST['module_id'];
        $module = $model->getModule($module_id);
        $returl = $input->get('returl', '', 'RAW');

        if (!$module) {
            $app->enqueueMessage(Text::_('COM_BACKCALL_ERROR_MODULE'), 'error');
            $app->redirect(\JUri::root());
        }

        $module_params = new Registry($module->params);

        $email = $module_params->get('email', '');
        $telegrams = $module_params->get('telegrams', '');
        $telegramIsActive = false;

        if (is_array($telegrams)) {
            if (count($telegrams)) {
                $telegramIsActive = true;
            }
        }

        $moduletype = $module_params->get('moduletype', 0);

        if (!$moduletype) {
            $object->phone =  $input->get('phone', '');
            $object->client_name =  $input->get('name' ,'', 'RAW');
            $name = $object->client_name;
        } else {

            $jform = $input->get('jform', '', 'array');
            $object = (object)$jform;
            $name = $object->client_name;
        }

        $object->created = date('Y-m-d H:i:s');

        $url_adress = $input->get('returl' ,'', 'RAW');

        if ($module_params->get('urlmessage', 0) == 1) {

            $urltext_email = Text::_('COM_BACKCALL_URL_TEXT');
            $urltext_email .= '<br>';
            $urltext_email .= '<a href="'.$url_adress.'">'.$url_adress.'</a>';

            $urltext_telegram = chr(10).Text::_('COM_BACKCALL_URL_TEXT');
            $urltext_telegram .= chr(10);
            $urltext_telegram .= $url_adress;
        } else {
            $urltext_email = '';
            $urltext_telegram = '';
        }

        $succes_text = Text::_('COM_BACKCALL_SUCCESS');

        $pos = strpos($object->client_name, 'http');

        if ($pos !== false) {
            die('spam protection');
        }

        $phone = preg_replace("/[^0-9]/", '', $object->phone);

        $phone_sms_lenght = strlen($phone);

        if ($phone_sms_lenght < 11 || !is_numeric($phone)) {
           $app->enqueueMessage('Неверный номер телефона');
           $app->redirect($returl);
        }

        $subject = $module_params->get('subjectemail', '');
        $subject = str_replace('{NAME}', $name, $subject);

        $db = Factory::getContainer()->get('DatabaseDriver');

        if ($email) {
            $mailer = Factory::getMailer();

            if (!$moduletype) {
                $body = $this->getBackcallBody($module_params, $object, $urltext_email);
                $db->insertObject('#__backcall_calls', $object);
            } else {

                $body = $this->getMessageBody($module_params, $object, $urltext_email);
                $object->subject = $subject;
                $db->insertObject('#__backcall_messages', $object);

                $object->id = $db->insertid();

                $files = $_FILES['files'];
                $files = $this->getFiles($files, $object->id);

                if (count($files)) {
                    foreach ($files as $file) {
                        $mailer->addAttachment($file['full']);
                    }

                    $object->files = json_encode($files);

                    $db->updateObject('#__backcall_messages', $object, 'id', true);
                }

            }

            $config = Factory::getConfig();
            $sender = array(
                $config->get('mailfrom')
            );

            $mailer->setSender($sender);

            $mailer->addRecipient($email);
            $mailer->setSubject($subject);
            $mailer->setBody($body);
            $mailer->isHtml(true);

            $mailer->Send();
        }



        if ($telegramIsActive) {
            $telegramBots = $model->getTelegrams($telegrams);

            if (!count($telegramBots)) {
                $app->enqueueMessage('COM_BACKCALL_ERROR_BOTS', 'error');
            } else {

                $telegramBody = $this->getTelegramBody($name, $phone, $module_params, $urltext_telegram, $subject);
                $recipients = array();
                $telegramHelper = new \telegramHelper();

                foreach ($telegramBots as $bot) {
                    $recipients[] = array('token'=> $bot->telegram_token, 'chat_id'=>$bot->telegram_chatid);
                }

                $telegramHelper->sendToTelegramm( $telegramBody, $recipients);

            }
        }


        // Если все прошло успешно, то выводим сообщение о том, что сообщение отправлено
        $app->enqueueMessage('<div class="backcallsucc" >' . $succes_text . '</div>');
        $app->redirect($returl);


    }

    public function getFiles($files,$record_id) {
        $MainHelper = new MainHelper();

        if (!is_array($files)) {
            return array();
        }

        if (isset($files['size'])) {
            if ($files['size'][0] == 0) {
                return array();
            }
        }

        $folder = $MainHelper->getMainComponentFilesFolder($record_id);

        $names = $files['name'];
        $result = array();

        foreach ($names as $key=>$name) {
            $from = $files['tmp_name'][$key];
            $to = $folder.DIRECTORY_SEPARATOR.$name;
            if (copy($from, $to)) {
                $result[] = array('name' =>$name, 'full'=>$to);
            }
        }

        return $result;
    }

    public function getBackcallBody($module_params, $object, $urltext_email) {

        $message = $module_params->get('messagetext','');

        if ($message) {
            $message_email = $message.'<br><br>';
        }

        $message_email = $message_email .
            Text::_('COM_BACKCALL_NAME') .
            $object->client_name . '<br>' .
            Text::_('COM_BACKCALL_PHONE') . $object->phone . '<br>' . $urltext_email;

        return $message_email;
    }

    public function getMessageBody($module_params, $object, $urltext_email) {
        $message = $module_params->get('messagetext','');

        if ($message) {
            $message_email = $message.'<br><br>';
        }

        $message_email = $message_email .
            Text::_('COM_BACKCALL_NAME') .
            $object->client_name . '<br>';
        if ($object->phone) {
            $message_email .=   Text::_('COM_BACKCALL_PHONE') . $object->phone . '<br>';
        }

        if ($object->email) {
            $message_email .=  Text::_('COM_BACKCALL_CALLS_EMAIL').': ' . $object->email . '<br>' .'<br>';
        }


         $message_email .=   '<br><strong>'.Text::_('COM_BACKCALL_ENTER_BODY').':</strong> <br><br>' . $object->body. '<br>' .'<br>'.
            $urltext_email;

        return $message_email;
    }

    public  function getTelegramBody($name, $phone,  $module_params, $urltext, $subject) {

        $message = $module_params->get('messagetext','');

        if ($subject) {
            $subject = '*'.$subject.'*'.chr(10).chr(10);
        } else {
            $subject = '';
        }

        if ($message) {
            $message = $message.chr(10) .chr(10) ;
        }

        $body = $subject.$message .
            Text::_('COM_BACKCALL_NAME') .
            $name .chr(10) .
            Text::_('COM_BACKCALL_PHONE') . $phone . chr(10) . $urltext;



        return $body;

    }

    public function checkSpamOborona() {

        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db
            ->getQuery(true)
            ->select('*')
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element') . " = " . $db->quote('honeysuckle'))
            ->where($db->quoteName('type') . " = " . $db->quote('plugin'));

        $db->setQuery($query);
        $result = $db->loadObject();

        return $result;
    }

}
