<?php


namespace Honeysuckle\Component\Honeysuckle\Site\View\Reset;
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Component\ComponentHelper;
use JUri;
use Honeysuckle\Component\Honeysuckle\Site\Helper\HoneysuckleHelper;
use stdClass;


class HtmlView extends BaseHtmlView
{
	protected $state;

	protected $item;

	protected $form;

	protected $params;


    
	public function display($tpl = null)
	{
        $app = Factory::getApplication();
        $this->item = $this->get('Item');

        if ($this->item) {
            if ($this->item->published == 1) {
                $app->redirect(JUri::root());
                return;
            }
        }

        $assetManager = Factory::getApplication()->getDocument()->getWebAssetManager();
        $assetManager->registerAndUseStyle('honeysucklesite', 'components/com_honeysuckle/assets/css/style.css', []);

        $HoneysuckleHelper = new HoneysuckleHelper();

        $session = $app->getSession();
        $new_session_id = $session->getID().'_honeysuckle';

        $this->item = $HoneysuckleHelper->getSessionBySessionId($new_session_id);

        if (!$this->item) {
            $c1 = rand(1, 15);
            $c2 = rand(1, 15);

            $object = new stdClass();
            $object->chislo1 = $c1;
            $object->chislo2 = $c2;
            $object->summa = $object->chislo1 + $object->chislo2;

            $this->chislo1 = $c1;
            $this->chislo2 = $c2;

            $object = json_encode($object);

            $HoneysuckleHelper->addToSessionTable($session->getID(), $object);

        } else {
            $data = json_decode($this->item->data);
            $this->chislo1 = $data->chislo1;
            $this->chislo2 = $data->chislo2;
        }

        $this->ip = $HoneysuckleHelper->getIp();


		parent::display($tpl);
	}


}
