<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Backcall
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Backcall\Component\Backcall\Site\Helper;

defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\Folder;
use \Joomla\CMS\MVC\Model\BaseDatabaseModel;

/**
 * Class BackcallFrontendHelper
 *
 * @since  1.0.0
 */
class MainHelper
{
    public function isJson($string)
    {
        return ((is_string($string) &&
            (is_object(json_decode($string)) ||
                is_array(json_decode($string))))) ? true : false;
    }

    public function deleteMessage($id) {
        $db = Factory::getContainer()->get('DatabaseDriver');

        $query = $db->getQuery(true);

        $conditions = array(
            $db->quoteName('id') . ' = '.$id,
        );

        $query->delete($db->quoteName('#__backcall_messages'));
        $query->where($conditions);

        $db->setQuery($query);

        $db->execute();
    }
    public function getMainComponentFilesFolder($id) {

        $path_main =  realpath(JPATH_ROOT . '/..');

        $system_folder = 'backcall';

        $path_component = $path_main.DIRECTORY_SEPARATOR.$system_folder;

        if (!is_dir($path_component)) {
            Folder::create($path_component);
        }

        $dop_dir  = $path_component.DIRECTORY_SEPARATOR.$id;

        if (!is_dir($dop_dir)) {
            Folder::create($dop_dir);
        }

        return $dop_dir;
    }

    public function remove_dir($dir)
    {
        if ($objs = glob($dir . '/*')) {
            foreach($objs as $obj) {
                is_dir($obj) ? $this->remove_dir($obj) : unlink($obj);
            }
        }
        rmdir($dir);
    }
}