<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\Field;

defined('JPATH_BASE') or die;

use \Joomla\CMS\Form\FormField;

/**
 * Supports an HTML select list of categories
 *
 * @since  1.0.0
 */
class FileMultipleField extends FormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  1.0.0
	 */
	protected $type = 'filemultiple';

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string    The field input markup.
	 *
	 * @since   1.0.0
	 */
	protected function getInput()
	{
		// Initialize variables.
		$html = '<input type="file" name="' . $this->name . '[]" multiple>';

		return $html;
	}
}
