<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\View\Instruments;
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use \Honeysuckle\Component\Honeysuckle\Administrator\Helper\HoneysuckleHelper;
use \Joomla\CMS\Toolbar\Toolbar;
use \Joomla\CMS\Toolbar\ToolbarHelper;
use \Joomla\CMS\Language\Text;
use \Joomla\Component\Content\Administrator\Extension\ContentComponent;
use \Joomla\CMS\Form\Form;
use \Joomla\CMS\HTML\Helpers\Sidebar;
/**
 * View class for a list of Logs.
 *
 * @since  1.0.0
 */
class HtmlView extends BaseHtmlView
{


	public function display($tpl = null)
	{

        HoneysuckleHelper::loadAssets();

		$this->addToolbar();

		$this->sidebar = Sidebar::render();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	protected function addToolbar()
	{
		$state = $this->get('State');
		$canDo = HoneysuckleHelper::getActions();

		ToolbarHelper::title(Text::_('COM_HONEYSUCKLE_INSTRUMENTS'), "generic");

		$toolbar = Toolbar::getInstance('toolbar');

		// Check if the form exists before showing the add/edit buttons
		$formPath = JPATH_COMPONENT_ADMINISTRATOR . '/src/View/Instruments';


		if ($canDo->get('core.admin'))
		{
			$toolbar->preferences('com_honeysuckle');
		}

		// Set sidebar action
		Sidebar::setAction('index.php?option=com_honeysuckle&view=instruments');
	}

}
