<?php
/**
 * @version    CVS: 1.0.0
 * @package    com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2021 Vladimir Egorov
 * @license    Commercial license
 */

namespace Honeysuckle\Component\Honeysuckle\Site\Controller;

\defined('_JEXEC') or die;


use JFile;
use Joomla\CMS\Application\CMSApplication;
use \Joomla\CMS\Application\SiteApplication;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Multilanguage;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Router\Route;
use Honeysuckle\Component\Honeysuckle\Site\Helper\HoneysuckleHelper;

class ResetController extends BaseController
{
    public function reset() {
        $HoneysuckleHelper = new HoneysuckleHelper();
        $app = Factory::getApplication();
        $input = $app->getInput();
        $session = $app->getSession();

        $new_session_id = $session->getID().'_honeysuckle';

        $link = Route::_('index.php?option=com_honeysuckle&view=reset');
        $ip = $HoneysuckleHelper->getIp();
        $user = $app->getIdentity();

        $DatabaseSession = $HoneysuckleHelper->getSessionBySessionId($new_session_id);

        if (!$DatabaseSession) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_EMPTY'), 'error');
            $app->redirect($link);
        }

        $data = json_decode($DatabaseSession->data);

        $summaObject =    $data;


        $otvet = $input->get('otvet', 0);
        $summa = $summaObject->summa;


        if ($otvet != $summa) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_INCORRECT'), 'error');
            $app->redirect($link);
        }

        $pluginParams = $HoneysuckleHelper->getPluginParams();

        $session_name_field = $pluginParams->get('session_name_field', '', 'RAW');

        if ($user->guest) {
            $check = $input->get($session_name_field, 0);

            if (!$check) {
                $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_SPAM'), 'error');
                $app->redirect($link);
            }
        }

        $currentRec = $HoneysuckleHelper->mainLib->checkIpFromSpamList($ip, 0);

        if (!$currentRec) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_NOREC'));
            $app->redirect(\JUri::root());
        }

        $HoneysuckleHelper->addToWhiteList();
        $HoneysuckleHelper->deleteSession($new_session_id);
        $HoneysuckleHelper->deleteOldSession();

        $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_SUCCESS_MESSAGE'));
        $app->redirect(\JUri::root());

    }

}