<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;
use stdClass;

/**
 * Logs list controller class.
 *
 * @since  1.0.0
 */
class InstrumentsController extends AdminController
{
    public function exporttxt() {

        $model = $this->getModel('Spams');
        $ips = $model->getSpams();

        $filename = 'honeysuckle_'.date('d-m-Y') . "_in_" . date('H-m-s') . '.txt';

        $content = implode(';', $ips);

        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . basename($filename));
        header('Content-Length: ' . filesize($filename));
        echo $content;
        exit;

    }

    public function import() {
        $app = Factory::getApplication();
        $input = $app->getInput();
        $link = '/administrator/index.php?option=com_honeysuckle&view=instruments';

        $file = $input->files->get('spamoboronaspams', '');

        if (!$file) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_LOAD'), 'error');
            $app->redirect($link);
        }

        if ($file['error']) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_LOAD'), 'error');
            $app->redirect($link);
        }

        if ($file['type'] != 'text/plain') {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_LOAD2'), 'error');
            $app->redirect($link);
        }

        $ips = file_get_contents($file['tmp_name']);

        if (trim($ips) == '') {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_LOAD2'), 'error');
            $app->redirect($link);
        }

        $ips = explode(';', $ips);

        if (!count($ips)) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_LOAD2'), 'error');
            $app->redirect($link);
        }

        $final_ips = array();

        foreach ($ips as $ip) {
            $i = explode('.', $ip);

            if (count($i) == 4) {
                $final_ips[] = $ip;
            }
        }

        $model = $this->getModel('Spams');
        $model->deleteips($final_ips);

        $c = 0;

        foreach ($final_ips as $ip) {
            $spam_user = new stdClass();
            $spam_user->ip = $ip;
            $spam_user->reason = Text::_('COM_HONEYSUCKLE_IMPORT_REASON');
            $spam_user->published = 0;
            $spam_user->created = date('Y-m-d H:i:s');

            Factory::getDbo()->insertObject('#__honeysuckle_spam', $spam_user);

            $c++;
        }

        $app->enqueueMessage(Text::sprintf('COM_HONEYSUCKLE_IMPORT_MESSAGE', $c));
        $app->redirect($link);

    }


}
