<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\Model;
// No direct access.
defined('_JEXEC') or die;

use \Joomla\CMS\MVC\Model\ListModel;
use \Joomla\Component\Fields\Administrator\Helper\FieldsHelper;
use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Helper\TagsHelper;
use \Joomla\Database\ParameterType;
use \Joomla\Utilities\ArrayHelper;
use Honeysuckle\Component\Honeysuckle\Administrator\Helper\HoneysuckleHelper;

/**
 * Methods supporting a list of Logs records.
 *
 * @since  1.0.0
 */
class Stop_wordsModel extends ListModel
{
    /**
     * Constructor.
     *
     * @param   array  $config  An optional associative array of configuration settings.
     *
     * @see        JController
     * @since      1.6
     */
    public function __construct($config = array())
    {
        if (empty($config['filter_fields']))
        {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'state', 'a.state',
                'ordering', 'a.ordering',
                'created_by', 'a.created_by',
                'modified_by', 'a.modified_by',
            );
        }

        parent::__construct($config);
    }








    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @param   string  $ordering   Elements order
     * @param   string  $direction  Order direction
     *
     * @return void
     *
     * @throws Exception
     */
    protected function populateState($ordering = null, $direction = null)
    {
        // List state information.
        parent::populateState("a.id", "ASC");

        $context = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
        $this->setState('filter.search', $context);

        // Split context into component and optional section
        $parts = FieldsHelper::extract($context);

        if ($parts)
        {
            $this->setState('filter.component', $parts[0]);
            $this->setState('filter.section', $parts[1]);
        }
    }

    /**
     * Method to get a store id based on model configuration state.
     *
     * This is necessary because the model is used by the component and
     * different modules that might need different sets of data or different
     * ordering requirements.
     *
     * @param   string  $id  A prefix for the store id.
     *
     * @return  string A store id.
     *
     * @since   1.0.0
     */
    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.state');


        return parent::getStoreId($id);

    }

    public function deleteall() {
        $db = Factory::getDbo();

        $query = $db->getQuery(true);


        $query->delete($db->quoteName('#__honeysuckle_spam'));


        $db->setQuery($query);

        $result = $db->execute();
    }


    protected function getListQuery()
    {
        $query = $this->getDbo()->getQuery( true );
        $query->select( 'a.*, a.published as state' );

        $query->from( '#__honeysuckle_stop_words as a' );
        $published = $this->getState( 'filter.published' );



        $search = $this->getState( 'filter.search' );
        $search = trim($search);
        if ( !empty( $search ) ) {
            $search = $this->getDbo()->Quote( '%' . $this->getDbo()->escape( $search, true ) . '%' );
            $query->where( '(a.log LIKE ' . $search . ' OR a.ip LIKE ' . $search . ')' );
        }
        $orderCol = $this->state->get( 'list.ordering' );
        $orderDirn = $this->state->get( 'list.direction' );
        //$query->order( $this->getDbo()->escape( $orderCol . ' ' . $orderDirn ) );
        return $query;
    }

    /**
     * Get an array of data items
     *
     * @return mixed Array of data items on success, false on failure.
     */
    public function getItems()
    {
        $items = parent::getItems();


        return $items;
    }
}
