<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Honeysuckle\Component\Honeysuckle\Administrator\Controller;

\defined('_JEXEC') or die;
require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;
use stdClass;

/**
 * Logs list controller class.
 *
 * @since  1.0.0
 */
class SpamsController extends AdminController
{
    public function publish()
    {
        $cids = $this->app->input->get('cid', '', 'array');
        $task = $this->app->input->get('task', '');
        $model = $this->getModel('Spam');

        $link = \JUri::base().'index.php?option=com_honeysuckle&view=spams';

        if (count($cids)) {
            foreach ($cids as $cid) {

                $one_ip = $model->getItem($cid);
                if ($task == 'unpublish') {
                    $value = 0;
                } else {
                    $value = 1;
                }
                $for_all_object = new stdClass();
                $for_all_object->ip = $one_ip->ip;
                $for_all_object->published = $value;

                if (!$one_ip->reason)
                {
                    $for_all_object->reason = '';
                } else {
                    $for_all_object->reason = $one_ip->reason;
                }
                //Factory::getDbo()->updateObject('#__honeysuckle_logs', $for_all_object, 'ip');
                Factory::getDbo()->updateObject('#__honeysuckle_spam', $for_all_object, 'ip');
            }
        }

        $this->app->enqueueMessage(Text::sprintf('COM_HONEYSUCKLE_N_ITEMS_ADDED_SPAM'.$value, count($cids)));
        $this->app->redirect($link);


    }


    public function deleteall() {
        $app = Factory::getApplication();

        $model = $this->getModel('Spams');

        $model->deleteall();

        $link = 'index.php?option=com_honeysuckle&view=spams';

        $this->app->enqueueMessage(Text::_('COM_HONEYSUCKLE_SUCCESS_OPERATION'));

        $app->redirect($link);
    }


    public function getModel($name = 'Spam', $prefix = 'Administrator', $config = array())
    {
        return parent::getModel($name, $prefix, array('ignore_request' => true));
    }



    /**
     * Method to save the submitted ordering values for records via AJAX.
     *
     * @return  void
     *
     * @since   1.0.0
     *
     * @throws  Exception
     */
    public function saveOrderAjax()
    {
        // Get the input
        $pks   = $this->input->post->get('cid', array(), 'array');
        $order = $this->input->post->get('order', array(), 'array');

        // Sanitize the input
        ArrayHelper::toInteger($pks);
        ArrayHelper::toInteger($order);

        // Get the model
        $model = $this->getModel();

        // Save the ordering
        $return = $model->saveorder($pks, $order);

        if ($return)
        {
            echo "1";
        }

        // Close the application
        Factory::getApplication()->close();
    }
}
