<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */


defined('_JEXEC') or die;


require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
/**
 * Class HoneysuckleFrontendHelper
 *
 * @since  1.0.0
 */
class HoneysuckleHelper
{

    public $mainLib;

    public function __construct() {
        $this->mainLib = new HoneysuckleMain();
    }
    public function getIp() {
        return $this->mainLib->getUserIpAddr();
    }

    public function getPluginParams() {

        $plugin       = JPluginHelper::getPlugin('system', 'honeysuckle');
        $pluginParams = new JRegistry($plugin->params);

        return $pluginParams;
    }

    public function addToWhiteList() {
        $ip = $this->getIp();
        $date = date('Y-m-d H:i:s');
        $reason = JText::sprintf('COM_HONEYSUCKLE_ADDING_WHITELIST_MESSAGE', $date);

        $spam_user = new stdClass();
        $spam_user->ip = $ip;
        $spam_user->reason = $reason;
        $spam_user->published = 1;
        $spam_user->created = $date;

        $db = JFactory::getDbo();
        $updateNulls = true;

        $result1 = $db->updateObject('#__honeysuckle_spam', $spam_user, 'ip', $updateNulls);

        $object = new stdClass();
        $object->ip = $ip;
        $object->published = 1;

        $result2 = $db->updateObject('#__honeysuckle_logs', $object, 'ip', $updateNulls);

        return $result1 + $result2;
    }




}
