<?php

// No direct access
defined( '_JEXEC' ) or die;

/**
 * @author Vladimir Egorov
 */
class HoneysuckleModelStop_words extends JModelList
{

    /**
     * Конструктор класса
     * @param Array $config
     */
    public function __construct( $config = array() )
    {
        if ( empty( $config['filter_fields'] ) ) {
            $config['filter_fields'] = array( 'title', 'state', 'ordering',  'created', 'id' );
        }
        parent::__construct( $config );
    }


    /**
     * @param String $ordering
     * @param String $direction
     */
    protected function populateState( $ordering = null, $direction = null )
    {
        if ( $layout = JFactory::getApplication()->input->get( 'layout' ) ) {
            $this->context .= '.' . $layout;
        }
        $search = $this->getUserStateFromRequest( $this->context . '.filter.search', 'filter_search' );
        $this->setState( 'filter.search', $search );
        $published = $this->getUserStateFromRequest( $this->context . '.filter.published', 'filter_published', '' );
        $this->setState( 'filter.published', $published );
        parent::populateState( 'id', 'desc' );
    }

    /**
     * @param string $id
     * @return string
     */
    protected function getStoreId( $id = '' )
    {
        $id .= ':' . $this->getState( 'filter.search' );
        $id .= ':' . $this->getState( 'filter.published' );
        $id .= ':' . $this->getState( 'filter.author_id' );
        return parent::getStoreId( $id );
    }

    /**
     * Составление запроса для получения списка записей
     * @return JDatabaseQuery
     */
    protected function getListQuery()
    {
        $query = $this->getDbo()->getQuery( true );
        $query->select( 't1.*, t1.published as state' );

        $query->from( '#__honeysuckle_stop_words as t1' );
        $published = $this->getState( 'filter.published' );



        $search = $this->getState( 'filter.search' );
        $search = trim($search);
        if ( !empty( $search ) ) {
            $search = $this->getDbo()->Quote( '%' . $this->getDbo()->escape( $search, true ) . '%' );
            $query->where( '(t1.log LIKE ' . $search . ' OR t1.ip LIKE ' . $search . ')' );
        }
        $orderCol = $this->state->get( 'list.ordering' );
        $orderDirn = $this->state->get( 'list.direction' );
        //$query->order( $this->getDbo()->escape( $orderCol . ' ' . $orderDirn ) );
        return $query;
    }


}