<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Backcall
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Backcall\Component\Backcall\Administrator\Controller;

\defined('_JEXEC') or die;

use Backcall\Component\Backcall\Site\Helper\MainHelper;
use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Utilities\ArrayHelper;

/**
 * Calls list controller class.
 *
 * @since  1.0.0
 */
class MessagesController extends AdminController
{
    public function download() {
        $app = Factory::getApplication();
        $input = $app->getInput();
        $link = '/administrator/index.php?option=com_backcall&view=messages';
        $MainHelper = new MainHelper();

        $user = $app->getIdentity();

        if ($user->guest) {
            $app->redirect(\JUri::base());
            return;
        }

        $id = $input->get('id', 0);

        if (!$id) {
            $app->redirect($link);
        }

        $file = $input->get('file', '', 'RAW');

        if (!$file) {
            $app->redirect($link);
        }

        ob_end_clean();
        $folder = $MainHelper->getMainComponentFilesFolder($id);
        $file = $folder.DIRECTORY_SEPARATOR.$file;

        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . basename($file));
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file));

        readfile($file);
        exit();
    }
    public function delete()
    {

        $app = Factory::getApplication();
        $input = $app->getInput();


        $cid = $input->get('cid', '', 'array');

        if (count($cid)) {
            $MainHelper = new MainHelper();
            foreach ($cid as $id) {
                $folder = $MainHelper->getMainComponentFilesFolder($id);
                $MainHelper->remove_dir($folder);
            }

        }

        parent::delete(); // TODO: Change the autogenerated stub
    }

    public function duplicate()
    {
        // Check for request forgeries
        $this->checkToken();

        // Get id(s)
        $pks = $this->input->post->get('cid', array(), 'array');

        try
        {
            if (empty($pks))
            {
                throw new \Exception(Text::_('COM_BACKCALL_NO_ELEMENT_SELECTED'));
            }

            ArrayHelper::toInteger($pks);
            $model = $this->getModel();
            $model->duplicate($pks);
            $this->setMessage(Text::_('COM_BACKCALL_ITEMS_SUCCESS_DUPLICATED'));
        }
        catch (\Exception $e)
        {
            Factory::getApplication()->enqueueMessage($e->getMessage(), 'warning');
        }

        $this->setRedirect('index.php?option=com_backcall&view=messages');
    }

    /**
     * Proxy for getModel.
     *
     * @param   string  $name    Optional. Model name
     * @param   string  $prefix  Optional. Class prefix
     * @param   array   $config  Optional. Configuration array for model
     *
     * @return  object	The Model
     *
     * @since   1.0.0
     */
    public function getModel($name = 'Message', $prefix = 'Administrator', $config = array())
    {
        return parent::getModel($name, $prefix, array('ignore_request' => true));
    }



    /**
     * Method to save the submitted ordering values for records via AJAX.
     *
     * @return  void
     *
     * @since   1.0.0
     *
     * @throws  Exception
     */
    public function saveOrderAjax()
    {
        // Get the input
        $pks   = $this->input->post->get('cid', array(), 'array');
        $order = $this->input->post->get('order', array(), 'array');

        // Sanitize the input
        ArrayHelper::toInteger($pks);
        ArrayHelper::toInteger($order);

        // Get the model
        $model = $this->getModel();

        // Save the ordering
        $return = $model->saveorder($pks, $order);

        if ($return)
        {
            echo "1";
        }

        // Close the application
        Factory::getApplication()->close();
    }
}
