<?php

// No direct access
defined( '_JEXEC' ) or die;
jimport('joomla.application.component.controlleradmin');

require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';

class HoneysuckleControllerLogs extends JControllerAdmin
{

    /**
     * Class constructor
     * @param array $config
     */
    function __construct( $config = array() )
    {
        $this->app = JFactory::getApplication();
        parent::__construct( $config );
    }

    public function publish()
    {
        $cids = $this->app->input->get('cid', '', 'array');
        $task = $this->app->input->get('task', '');
        $model = $this->getModel('Log');

        $link = JRoute::_('index.php?option=com_honeysuckle&view=logs');

        if (count($cids)) {
            foreach ($cids as $cid) {

                $one_log = $model->getItem($cid);
                if ($task == 'unpublish') {
                    $value = 0;
                } else {
                    $value = 1;
                }
                $this->changeSpamList($one_log, $model, $value);
            }
        }

        $this->app->redirect($link,JText::sprintf('COM_HONEYSUCKLE_N_ITEMS_ADDED_SPAM'.$value, count($cids)));


    }

    public function changeSpamList($one_log, $model, $value)
    {
        $object = new stdClass();
        $object->ip = $one_log->ip;
        $HoneysuckleMain = new HoneysuckleMain();

        $current_ip = $model->getIpFromSpamList($one_log->ip);

        if (!$value) {
            $object->reason = $one_log->log;
        } else {
            $object->reason = '';
        }

        $object->published = $value;

        if ($current_ip) {
            $object->created = $current_ip->created;
            $object->id = $current_ip->id;

            JFactory::getDbo()->updateObject('#__honeysuckle_spam', $object, 'id');
        } else {
            if (!$value) {
                $HoneysuckleMain->addToSpam($one_log->ip, $object->reason);
            } else {
                $HoneysuckleMain->addToWhite($one_log->ip, $object->reason);
            }

        }

        $for_all_object = new stdClass();
        $for_all_object->ip = $object->ip;
        $for_all_object->published = $value;

        JFactory::getDbo()->updateObject('#__honeysuckle_logs', $for_all_object, 'ip');

    }

    /**
     * Method to get current model
     * @param String $name (model name)
     * @param String $prefix (model prefox)
     * @param Array $config
     * @return model for current element
     */
    public function getModel( $name = 'Log', $prefix = 'HoneysuckleModel', $config = array( 'ignore_request' => true ) )
    {
        return parent::getModel( $name, $prefix, $config );
    }

    public function deleteall() {
        $app = JFactory::getApplication();

        $model = $this->getModel('Logs');

        $model->deleteall();

        $link = 'index.php?option=com_honeysuckle&view=logs';

        $app->redirect($link, JText::_('COM_HONEYSUCKLE_SUCCESS_OPERATION'));
    }

    /**
     * Method to save the submitted ordering values for records via AJAX.
     * @return    void
     */
    public function saveOrderAjax()
    {
        $pks = $this->input->post->get( 'cid', array(), 'array' );
        $order = $this->input->post->get( 'order', array(), 'array' );

        // Sanitize the input
        JArrayHelper::toInteger( $pks );
        JArrayHelper::toInteger( $order );

        // Get the model
        $model = $this->getModel();

        // Save the ordering
        $return = $model->saveorder( $pks, $order );

        if ( $return ) {
            echo '1';
        }

        // Close the application
        JFactory::getApplication()->close();
    }
}