<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Joomla\Component\Honeysuckle\Site\Helper;

defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Model\BaseDatabaseModel;
use HoneysuckleMain;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;
use stdClass;
if (file_exists(JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php')) {
    require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/honeysuckle/libs/main.php';
}

/**
 * Class HoneysuckleFrontendHelper
 *
 * @since  1.0.0
 */
class HoneysuckleHelper
{

    public $mainLib;

    public function __construct() {
        if (class_exists('HoneysuckleMain')) {
            $this->mainLib = new HoneysuckleMain();
        } else {
            $app = Factory::getApplication();
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_NOT_INSTALLED_PLUGIN'), 'error');
            $app->redirect(Uri::root());
        }
    }
	public function getIp() {
        return $this->mainLib->getUserIpAddr();
    }

    public function getPluginParams() {

        $plugin       = PluginHelper::getPlugin('system', 'honeysuckle');
        $pluginParams = new Registry($plugin->params);

        return $pluginParams;
    }

    public function deleteSession($session_id) {
        $db = Factory::getContainer()->get('DatabaseDriver');

        $query = $db->getQuery(true);

        $conditions = array(
            $db->quoteName('session_id') . ' = '.$db->quote($session_id),
        );

        $query->delete($db->quoteName('#__session'));
        $query->where($conditions);

        $db->setQuery($query);

        $db->execute();
    }

    public function deleteOldSession() {
        $time = time();
        $db = Factory::getContainer()->get('DatabaseDriver');

        $query = $db->getQuery(true);

        $conditions = array(
            $db->quoteName('session_id') . ' LIKE '.$db->quote('%honeysuckle%'),
            $db->quoteName('time') . ' < '.$time,
        );

        $query->delete($db->quoteName('#__session'));
        $query->where($conditions);

        $db->setQuery($query);

        $db->execute();
    }

    public function getSessionBySessionId($session_id) {
        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db
            ->getQuery(true)
            ->select('*')
            ->from($db->quoteName('#__session'))
            ->where($db->quoteName('session_id') . " = " . $db->quote($session_id));

        $db->setQuery($query);
        $result = $db->loadObject();

        return $result;
    }

    public function addToSessionTable($session_id, $data) {
        $session_id = $session_id.'_honeysuckle';
        $session = $this->getSessionBySessionId($session_id);

        if (!$session) {
            $db = Factory::getContainer()->get('DatabaseDriver');
            $object = new stdClass();
            $object->session_id = $session_id;
            $object->data = $data;
            $object->time = $time = time() + 3600;;
            $object->username = '';

            $db->insertObject('#__session', $object);
        }

    }

    public function addToWhiteList() {
        $ip = $this->getIp();
        $date = date('Y-m-d H:i:s');
        $reason = Text::sprintf('COM_HONEYSUCKLE_ADDING_WHITELIST_MESSAGE', $date);

        $spam_user = new stdClass();
        $spam_user->ip = $ip;
        $spam_user->reason = $reason;
        $spam_user->published = 1;
        $spam_user->created = $date;

        $db = Factory::getContainer()->get('DatabaseDriver');
        $updateNulls = true;

        $result1 = $db->updateObject('#__honeysuckle_spam', $spam_user, 'ip', $updateNulls);

        $object = new stdClass();
        $object->ip = $ip;
        $object->published = 1;

        $result2 = $db->updateObject('#__honeysuckle_logs', $object, 'ip', $updateNulls);

        return $result1 + $result2;
    }




}
