<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_tags
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Registry\Registry;
use Honeysuckle\Component\Honeysuckle\Site\Helper\HoneysuckleHelper;


/**
 * HTML View class for the Tags component
 *
 * @since  3.1
 */
class HoneysuckleViewReset extends JViewLegacy
{
	protected $state;

	protected $items;

	protected $item;

	protected $pagination;

	protected $params;

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed   A string if successful, otherwise an Error object.
	 */
	public function display($tpl = null)
	{
        $app = Factory::getApplication();
        $this->item = $this->get('Item');

        if ($this->item) {
            if ($this->item->published == 1) {
                $app->redirect(JUri::root());
                return;
            }
        } else {
            $app->redirect(JUri::root());
            return;
        }

        $document = Factory::getDocument();
        $document->addStyleSheet('/components/com_honeysuckle/assets/css/style.css');


        $HoneysuckleHelper = new HoneysuckleHelper();

        $session = $app->getSession();

        $object = new stdClass();
        $object->chislo1 = rand(1, 15);
        $object->chislo2 = rand(1, 15);
        $object->summa = $object->chislo1 + $object->chislo2;

        $this->chislo1 = $object->chislo1;
        $this->chislo2 = $object->chislo2;

        $spam_summa = $session->get('spam_summa', '');

        if ($spam_summa == '') {
            $object = json_encode($object);
            $session->set('spam_summa', $object);
        }



        $this->ip = $HoneysuckleHelper->getIp();


        parent::display($tpl);

	}

	/**
	 * Prepares the document
	 *
	 * @return void
	 */
	protected function _prepareDocument()
	{
		$app   = JFactory::getApplication();
		$menus = $app->getMenu();
		$title = null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_TAGS_DEFAULT_PAGE_TITLE'));
		}

		if ($menu && (!isset($menu->query['option']) || $menu->query['option'] !== 'com_tags'))
		{
			$this->params->set('page_subheading', $menu->title);
		}

		// Set metadata for all tags menu item
		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}

		// If this is not a single tag menu item, set the page title to the tag titles
		$title = '';

		if (!empty($this->item))
		{
			foreach ($this->item as $i => $itemElement)
			{
				if ($itemElement->title)
				{
					if ($i != 0)
					{
						$title .= ', ';
					}

					$title .= $itemElement->title;
				}
			}

			if (empty($title))
			{
				$title = $app->get('sitename');
			}
			elseif ($app->get('sitename_pagetitles', 0) == 1)
			{
				$title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
			}
			elseif ($app->get('sitename_pagetitles', 0) == 2)
			{
				$title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
			}

			$this->document->setTitle($title);

			foreach ($this->item as $itemElement)
			{
				if ($itemElement->metadesc)
				{
					$this->document->setDescription($this->item->metadesc);
				}
				elseif ($this->params->get('menu-meta_description'))
				{
					$this->document->setDescription($this->params->get('menu-meta_description'));
				}

				if ($itemElement->metakey)
				{
					$this->document->setMetadata('keywords', $this->tag->metakey);
				}
				elseif ($this->params->get('menu-meta_keywords'))
				{
					$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
				}

				if ($this->params->get('robots'))
				{
					$this->document->setMetadata('robots', $this->params->get('robots'));
				}

				if ($app->get('MetaAuthor') == '1')
				{
					$this->document->setMetaData('author', $itemElement->created_user_id);
				}

				$mdata = $this->item->metadata->toArray();

				foreach ($mdata as $k => $v)
				{
					if ($v)
					{
						$this->document->setMetadata($k, $v);
					}
				}
			}
		}

		// Respect configuration Sitename Before/After for TITLE in views All Tags.
		if (!$title && ($pos = $app->get('sitename_pagetitles', 0)))
		{
			$title = $this->document->getTitle();

			if ($pos == 1)
			{
				$title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
			}
			else
			{
				$title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
			}

			$this->document->setTitle($title);
		}

		// Add alternative feed link
		if ($this->params->get('show_feed_link', 1) == 1)
		{
			$link    = '&format=feed&limitstart=';
			$attribs = array('type' => 'application/rss+xml', 'title' => 'RSS 2.0');
			$this->document->addHeadLink(JRoute::_($link . '&type=rss'), 'alternate', 'rel', $attribs);
			$attribs = array('type' => 'application/atom+xml', 'title' => 'Atom 1.0');
			$this->document->addHeadLink(JRoute::_($link . '&type=atom'), 'alternate', 'rel', $attribs);
		}
	}
}
