<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_honeysuckle
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Joomla\Component\Honeysuckle\Administrator\Helper;
// No direct access
defined('_JEXEC') or die;

use \Joomla\CMS\Factory;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\Object\CMSObject;

/**
 * Honeysuckle helper.
 *
 * @since  1.0.0
 */
class HoneysuckleHelper
{
	public static function loadAssets() {

        $filemtime = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'administrator/components/com_honeysuckle/assets/css/honeysuckle.css');
        $filemtime_script = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'administrator/components/com_honeysuckle/assets/scripts/admin.js');
        $assetManager = Factory::getApplication()->getDocument()->getWebAssetManager();
        $assetManager->registerAndUseStyle('spamoborona_admin', 'administrator/components/com_honeysuckle/assets/css/honeysuckle.css', ['version' => 'v='.$filemtime]);
        $assetManager->registerAndUseScript('spamoborona_jqueryjs', 'administrator/components/com_honeysuckle/assets/scripts/jquery-3.6.4.min.js', []);
        $assetManager->registerAndUseScript('spamoborona_adminjs', 'administrator/components/com_honeysuckle/assets/scripts/admin.js', ['v='.$filemtime_script]);
    }

    public static function showDonat() {
        $donat = '
<div id="supportTheAuthorBlock">
    <div class="row">
        <div class="col-md-6">
            <h4>' . Text::_('COM_HONEYSUCKLE_YOUR_LIKE_COMPONENT') . '</h4><p>' . Text::_('COM_HONEYSUCKLE_SUPPORT_AUTHOR') . '</p>
        </div>
        <div class="col-md-6">
            <a href="https://sitogon.ru/donats/podderzhka-razvitiya-komponenta-zhimolost" class="btn btn-danger btn-support" target="_blank">
                ' . Text::_('COM_HONEYSUCKLE_DONAT') . '
            </a>
        </div>
    </div>
</div>';

        return $donat;
    }


	public static function getFiles($pk, $table, $field)
	{
		$db = Factory::getContainer()->get('DatabaseDriver');
		$query = $db->getQuery(true);

		$query
			->select($field)
			->from($table)
			->where('id = ' . (int) $pk);

		$db->setQuery($query);

		return explode(',', $db->loadResult());
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return  CMSObject
	 *
	 * @since   1.0.0
	 */
	public static function getActions()
	{
		$user = Factory::getApplication()->getIdentity();
		$result = new CMSObject;

		$assetName = 'com_honeysuckle';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}

