<?php

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Honeysuckle\Component\Honeysuckle\Site\Helper\HoneysuckleHelper;

defined('_JEXEC') or die;
class HoneysuckleControllerReset extends JControllerLegacy
{

    public function reset() {
        $HoneysuckleHelper = new HoneysuckleHelper();
        $app = Factory::getApplication();
        $input = $app->input;
        $session = $app->getSession();
        $link = Route::_('index.php?option=com_honeysuckle&view=reset');
        $ip = $HoneysuckleHelper->getIp();
        $user = $app->getIdentity();


        $summaObject =    $session->get('spam_summa', '');


        if ($summaObject == '') {
            $session->set('spam_summa', '');
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_EMPTY'), 'error');
            $app->redirect($link);
        }

        $summaObject = (object)json_decode($summaObject);

        $otvet = $input->get('otvet', 0);
        $summa = $summaObject->summa;

        if ($otvet != $summa) {
            $session->set('spam_summa', '');
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_INCORRECT'), 'error');
            $app->redirect($link);
        }

        $pluginParams = $HoneysuckleHelper->getPluginParams();

        $session_name_field = $pluginParams->get('session_name_field', '', 'RAW');

        if ($user->guest) {
            $session->set('spam_summa', '');
            $check = $input->get($session_name_field, 0);

            if (!$check) {
                $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_SPAM'), 'error');
                $app->redirect($link);
            }
        }

        $currentRec = $HoneysuckleHelper->mainLib->checkIpFromSpamList($ip, 0);

        if (!$currentRec) {
            $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_ERROR_NOREC'));
            $app->redirect(\JUri::root());
        }

        $HoneysuckleHelper->addToWhiteList();

        $session->set('spam_summa', '');

        $app->enqueueMessage(Text::_('COM_HONEYSUCKLE_SUCCESS_MESSAGE'));
        $app->redirect(\JUri::root());

    }

}