<?php
// No direct access
use Joomla\CMS\Factory;

defined( '_JEXEC' ) or die;

class plgSystemHoneysuckleInstallerScript
{

	function postflight( $type, $parent )
	{
        if ($type == 'install' || $type == 'update') {
            $mainpath = JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'honeysuckle';
            $dirs = array();
            $dirs[] = 'libs'.DIRECTORY_SEPARATOR.'didom';
            $dirs[] = 'libs'.DIRECTORY_SEPARATOR.'phpQuery';

            foreach ($dirs as $dir) {
                $this->removeDirectory($mainpath.DIRECTORY_SEPARATOR.$dir);
            }

            $files = array();
            $files[] = 'libs'.DIRECTORY_SEPARATOR.'com_contact.php';
            $files[] = 'libs'.DIRECTORY_SEPARATOR.'com_kunena.php';
            $files[] = 'libs'.DIRECTORY_SEPARATOR.'com_users.php';
            $files[] = 'libs'.DIRECTORY_SEPARATOR.'one_page.php';
            $files[] = 'libs'.DIRECTORY_SEPARATOR.'phpQuery.php';
            $files[] = 'libs'.DIRECTORY_SEPARATOR.'virtuemart.php';

            foreach ($files as $file) {
                $this->removeFile($mainpath.DIRECTORY_SEPARATOR.$file);
            }

        }

	}

    public function removeFile($file) {
        if (!file_exists($file)) {
            return;
        }

        unlink($file);
    }

    public function removeDirectory($dir) {

        if (!file_exists($dir)) {
            return;
        }

        if ($objs = glob($dir."/*")) {
            foreach($objs as $obj) {
                is_dir($obj) ? $this->removeDirectory($obj) : unlink($obj);
            }
        }
        rmdir($dir);
    }
}