<?php
/**
 * @version    CVS: 1.0.0
 * @package    Com_Backcall
 * @author     Владимир <mail@sitogon.ru>
 * @copyright  2022 Владимир
 * @license    GNU General Public License версии 2 или более поздней; Смотрите LICENSE.txt
 */

namespace Backcall\Component\Backcall\Site\Controller;

\defined('_JEXEC') or die;

use \Joomla\CMS\Application\SiteApplication;
use \Joomla\CMS\Factory;

use \Joomla\CMS\Language\Multilanguage;
use \Joomla\CMS\Language\Text;
use \Joomla\CMS\MVC\Controller\BaseController;
use \Joomla\CMS\Router\Route;
use \Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;
use \Joomla\Utilities\ArrayHelper;
use stdClass;

require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'components/com_backcall/src/Helper/telegram.php';
/**
 * Call class.
 *
 * @since  1.6.0
 */
class CallController extends BaseController
{

    public function send()
    {
        $app = Factory::getApplication();
        $input = $app->getInput();

        $checkSpamOborona = $this->checkSpamOborona();

        if ($checkSpamOborona) {
            require_once JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/system/spam_oborona/libs/main.php';
            $spamParams = $checkSpamOborona->params;
            $Spam_OboronaMain = new \Spam_OboronaMain($spamParams);

            $spamParams = new Registry($spamParams);
            $field_name = $spamParams->get('session_name_field', '');

            if ($field_name) {
                $check = $input->get($field_name, 0);
                if(!$check) {

                    $ip = $Spam_OboronaMain->getUserIpAddr();
                    $Spam_OboronaMain->addToSpam($ip, print_r($_REQUEST, true));
                    die('You Spam Bot!');
                }

            }
        }

        $model = $this->getModel('Call');

        $module_id = $_POST['module_id'];
        $module = $model->getModule($module_id);
        $returl = $input->get('returl', '', 'RAW');

        if (!$module) {
            $app->enqueueMessage(Text::_('COM_BACKCALL_ERROR_MODULE'), 'error');
            $app->redirect(\JUri::root());
        }

        $module_params = new Registry($module->params);

        $email = $module_params->get('email', '');
        $telegrams = $module_params->get('telegrams', '');
        $telegramIsActive = false;

        if (is_array($telegrams)) {
            if (count($telegrams)) {
                $telegramIsActive = true;
            }
        }

        $phone = $input->get('phone', '');
        $name = $input->get('name' ,'', 'RAW');

        $message = $module_params->get('messagetext','');

        $url_adress = $input->get('returl' ,'', 'RAW');

        if ($module_params->get('urlmessage', 0) == 1) {

            $urltext_email = Text::_('COM_BACKCALL_URL_TEXT');
            $urltext_email .= '<br>';
            $urltext_email .= '<a href="'.$url_adress.'">'.$url_adress.'</a>';

            $urltext_telegram = chr(10).Text::_('COM_BACKCALL_URL_TEXT');
            $urltext_telegram .= chr(10);
            $urltext_telegram .= $url_adress;
        } else {
            $urltext_email = '';
            $urltext_telegram = '';
        }

        $succes_text = Text::_('COM_BACKCALL_SUCCESS');


        $pos = strpos($name, 'http');

        if ($pos !== false) {
            die('spam protection');
        }

        $phone = preg_replace("/[^0-9]/", '', $phone);

        $phone_sms_lenght = strlen($phone);

        if ($phone_sms_lenght < 11 || !is_numeric($phone)) {
           $app->enqueueMessage('Неверный номер телефона');
           $app->redirect($returl);
        }


        $subject = $module_params->get('subjectemail', 0);

        $object = new stdClass();
        $object->phone = $phone;
        $object->client_name = $name;
        $object->created = date('Y-m-d H:i:s');

        $db = Factory::getContainer()->get('DatabaseDriver');

        $db->insertObject('#__backcall_calls', $object);

        if ($email) {
            $mailer = Factory::getMailer();

            if ($message) {
                $message_email = $message.'<br><br>';
            }

            $message_email = $message_email .
                Text::_('COM_BACKCALL_NAME') .
                $name . '<br>' .
                Text::_('COM_BACKCALL_PHONE') . $phone . '<br>' . $urltext_email;

            $config = Factory::getConfig();
            $sender = array(
                $config->get('mailfrom')
            );

            $mailer->setSender($sender);

            $mailer->addRecipient($email);
            $mailer->setSubject($subject);
            $mailer->setBody($message_email);
            $mailer->isHtml(true);

            $mailer->Send();
        }

        if ($telegramIsActive) {
            $telegramBots = $model->getTelegrams($telegrams);

            if (!count($telegramBots)) {
                $app->enqueueMessage('COM_BACKCALL_ERROR_BOTS', 'error');
            } else {

                $telegramBody = $this->getTelegramBody($name, $phone, $message, $urltext_telegram, $subject);
                $recipients = array();
                $telegramHelper = new \telegramHelper();

                foreach ($telegramBots as $bot) {
                    $recipients[] = array('token'=> $bot->telegram_token, 'chat_id'=>$bot->telegram_chatid);
                }

                $telegramHelper->sendToTelegramm( $telegramBody, $recipients);

            }
        }


        // Если все прошло успешно, то выводим сообщение о том, что сообщение отправлено
        $app->enqueueMessage('<div class="backcallsucc" >' . $succes_text . '</div>');
        $app->redirect($returl);


    }

    public  function getTelegramBody($name, $phone,  $message, $urltext, $subject) {

        if ($subject) {
            $subject = '*'.$subject.'*'.chr(10).chr(10);
        } else {
            $subject = '';
        }

        if ($message) {
            $message = $message.chr(10) .chr(10) ;
        }

        $body = $subject.$message .
            Text::_('COM_BACKCALL_NAME') .
            $name .chr(10) .
            Text::_('COM_BACKCALL_PHONE') . $phone . chr(10) . $urltext;



        return $body;

    }

    public function checkSpamOborona() {

        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db
            ->getQuery(true)
            ->select('*')
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('element') . " = " . $db->quote('spam_oborona'))
            ->where($db->quoteName('type') . " = " . $db->quote('plugin'));

        $db->setQuery($query);
        $result = $db->loadObject();

        return $result;
    }

}
