<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  editors-xtd.insertsitogonrutube
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\SiteRouter;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\EditorsXtd\Insertsitogonrutube\Extension\Insertsitogonrutube;

return new class () implements ServiceProviderInterface {


    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin     = new Insertsitogonrutube(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('editors-xtd', 'insertsitogonrutube')
                );
                $plugin->setApplication(Factory::getApplication());
                $plugin->setSiteRouter($container->get(SiteRouter::class));

                return $plugin;
            }
        );
    }
};
