<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  system.sitogonchosen
 *
 * @copyright   www.sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\SiteRouter;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\System\Sitogonchosen\Extension\Sitogonchosen;

return new class () implements ServiceProviderInterface {


    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin     = new Sitogonchosen(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('system', 'sitogonchosen')
                );
                $plugin->setApplication(Factory::getApplication());


                return $plugin;
            }
        );
    }
};
