<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  editors-xtd.insertsitogonrutube
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Plugin\EditorsXtd\Insertsitogonrutube\Extension;

use Joomla\CMS\Editor\Button\Button;
use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\Router;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;


\defined('_JEXEC') or die;


/**
 * Кнопка для редактора - вставка RUTUBE видео
 *
 * 1.0.0
 */
final class Insertsitogonrutube extends CMSPlugin implements SubscriberInterface
{
    use SiteRouterAwareTrait;
    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;

    public static function getSubscribedEvents(): array
    {
        return ['onEditorButtonsSetup' => 'onEditorButtonsSetup'];
    }


    public function onEditorButtonsSetup(EditorButtonsSetupEvent $event)
    {
        $subject  = $event->getButtonsRegistry();
        $disabled = $event->getDisabledButtons();

        if (\in_array($this->_name, $disabled)) {
            return;
        }

        $this->loadLanguage();

        $button = $this->onDisplay($event->getEditorId());
        $subject->add($button);
    }
    public function onDisplay($name)
    {
        // Register the asset "editor-button.<button name>", will be loaded by the button layout
        $this->getApplication()->getDocument()->getWebAssetManager()
            ->registerScript(
                'editor-button.' . $this->_name,
                'plugins/editors-xtd/insertsitogonrutube/assets/button.js',
                [],
                ['type' => 'module'],
                ['editors', 'joomla.dialog']
            );

        Text::script('PLG_INSERTSITOGONRUTUBE_PLEASE');

        $button = new Button(
            $this->_name,
            [
                'action'  => 'insert-sitogonrutube',
                'text'    => Text::_('PLG_INSERTSITOGONRUTUBE_BUTTON_INSERT'),
                'icon'    => 'fa-solid fa-video',
                // This is whole Plugin name, it is needed for keeping backward compatibility
                'name' => $this->_type . '_' . $this->_name,
            ]
        );
        return $button;
    }
}
