<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  system.sitogonrutube
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Plugin\System\Sitogonrutube\Extension;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\Router;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;


\defined('_JEXEC') or die;


/**
 * RUTUBE - вставка на сайт
 *
 * 1.0.0
 */
final class Sitogonrutube extends CMSPlugin implements SubscriberInterface
{
    use SiteRouterAwareTrait;
    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;


    public static function getSubscribedEvents(): array
    {
        return [
            'onAfterRender'     => 'onAfterRender',
        ];
    }


    public function onAfterRender()
    {

        $app = Factory::getApplication();

        if (!$app->isClient('site')) {
            return;
        }

        $body = $app->getBody();

        $body = str_replace('{RUTUBE}', '<iframe ', $body);
        $body = str_replace('{/RUTUBE}', '></iframe>', $body);

        $app->setBody($body);
    }


}
