import { JoomlaEditor, JoomlaEditorButton } from 'editor-api';
import JoomlaDialog from 'joomla.dialog';

/**
 * @copyright  (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
const insertSitogonvkvideoHandler = editor => {
    const content = editor.getValue();
    var htmlString = prompt(Joomla.Text._('PLG_INSERTSITOGONVKVIDEO_PLEASE'));

    const tempDiv = document.createElement('div');
    tempDiv.innerHTML = htmlString;

    const element = tempDiv.firstChild;

    const attributes = {};
    for (let i = 0; i < element.attributes.length; i++) {
        const attr = element.attributes[i];
        attributes[attr.name] = attr.value;
    }

    var text = '{VKVIDEO}';

    jQuery.each(attributes, function(key, value){
        text += key + '="' + value +'" ';
    });

    text += '{/VKVIDEO}'

    editor.replaceSelection(text);
};

// @TODO: Remove in Joomla 6
window.insertReadmore = () => {
    // eslint-disable-next-line no-console
    console.warn('Method window.insertReadmore() is deprecated, use button action "insert-readmore."');
    const editor = JoomlaEditor.getActive();
    if (!editor) {
        throw new Error('An active editor are not available');
    }
    insertReadmoreHandler(editor);
};
JoomlaEditorButton.registerAction('insert-sitogonvkvideo', insertSitogonvkvideoHandler);