<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  editors-xtd.insertsitogonrutube
 *
 * @copyright   sitogon.ru
 * @license     GNU General Public License version 2 or later;
 */

namespace Joomla\Plugin\EditorsXtd\Insertsitogonrutube\Extension;

use Joomla\CMS\Editor\Button\Button;
use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Router\Router;
use Joomla\CMS\Router\SiteRouter;
use Joomla\CMS\Router\SiteRouterAwareTrait;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\UserFactoryAwareTrait;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Joomla\Registry\Registry;


\defined('_JEXEC') or die;


/**
 * Кнопка для редактора - вставка RUTUBE видео
 *
 * 1.0.0
 */
final class Insertsitogonrutube extends CMSPlugin implements SubscriberInterface
{
    use SiteRouterAwareTrait;
    use DatabaseAwareTrait;
    use UserFactoryAwareTrait;

    public static function getSubscribedEvents(): array
    {
        return ['onEditorButtonsSetup' => 'onEditorButtonsSetup'];
    }


    public function onEditorButtonsSetup(EditorButtonsSetupEvent $event)
    {
        $subject  = $event->getButtonsRegistry();
        $disabled = $event->getDisabledButtons();

        if (\in_array($this->_name, $disabled)) {
            return;
        }

        $this->loadLanguage();

        $button = $this->onDisplay($event->getEditorId());
        $subject->add($button);
    }
    public function onDisplay($name)
    {
        Text::script('PLG_INSERTSITOGONRUTUBE_PLEASE');
        Text::script('PLG_INSERTSITOGONRUTUBE');
        Text::script('PLG_INSERTSITOGONRUTUBE_VIDEO_SIZE');
        Text::script('PLG_INSERTSITOGONRUTUBE_AUTOPLAY');
        Text::script('PLG_INSERTSITOGONRUTUBE_CANCEL');
        Text::script('PLG_INSERTSITOGONRUTUBE_INSERT');
        Text::script('PLG_INSERTSITOGONRUTUBE_INCORRECT_LINK');

        $Systemplugin       = PluginHelper::getPlugin('system', 'sitogonrutube');
        $pluginParams = new Registry((array)json_decode($Systemplugin->params));
        $loadIziModalBeforeBody        = $pluginParams->get('loadIziModalBeforeBody', 0);


        HTMLHelper::_('jquery.framework');
        $filemtime_vksitogon = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/editors-xtd/insertsitogonrutube/assets/rutubesitogon.js');
        $filemtime_button = filemtime(JPATH_ROOT.DIRECTORY_SEPARATOR.'plugins/editors-xtd/insertsitogonrutube/assets/button.js');

        $assetManager = Factory::getApplication()->getDocument()->getWebAssetManager();

        if ($loadIziModalBeforeBody != 2) {
            $assetManager->registerAndUseStyle('iziModalCss', Uri::root() . 'plugins/editors-xtd/insertsitogonrutube/assets/iziModal.css', []);
        }

        if (!$loadIziModalBeforeBody) {
            $assetManager->registerAndUseScript('iziModalJS', Uri::root() . 'plugins/editors-xtd/insertsitogonrutube/assets/iziModal.js', []);
        }

        $assetManager->registerAndUseScript('rutubesitogon', Uri::root().'plugins/editors-xtd/insertsitogonrutube/assets/rutubesitogon.js', ['version' => 'ver='.$filemtime_vksitogon]);
        
        
        
        // Register the asset "editor-button.<button name>", will be loaded by the button layout
        $this->getApplication()->getDocument()->getWebAssetManager()
            ->registerScript(
                'editor-button.' . $this->_name,
                'plugins/editors-xtd/insertsitogonrutube/assets/button.js',
                ['version' => 'v='.$filemtime_button],
                ['type' => 'module'],
                ['editors', 'joomla.dialog']
            );

        Text::script('PLG_INSERTSITOGONRUTUBE_PLEASE');

        $button = new Button(
            $this->_name,
            [
                'action'  => 'insert-sitogonrutube',
                'text'    => Text::_('PLG_INSERTSITOGONRUTUBE_BUTTON_INSERT'),
                'icon'    => 'fa-solid fa-video',
                // This is whole Plugin name, it is needed for keeping backward compatibility
                'name' => $this->_type . '_' . $this->_name,
                'iconSVG' => '<svg width="24" height="24" viewBox="0 0 192 192"><path fill="#ffffff" d="M128.689 47.57H20.396v116.843h30.141V126.4h57.756l26.352 38.013h33.75l-29.058-38.188c9.025-1.401 15.522-4.73 19.493-9.985 3.97-5.255 5.956-13.664 5.956-24.875v-8.759c0-6.657-.721-11.912-1.985-15.941-1.264-4.029-3.43-7.533-6.498-10.686-3.249-2.978-6.858-5.08-11.19-6.481-4.332-1.226-9.747-1.927-16.424-1.927zm-4.873 53.08H50.537V73.321h73.279c4.15 0 7.038.7 8.482 1.927 1.444 1.226 2.347 3.503 2.347 6.832v9.81c0 3.503-.903 5.78-2.347 7.006s-4.331 1.752-8.482 1.752z" style="display:inline;fill:none;stroke:#000000;stroke-width:12;stroke-linecap:round;stroke-linejoin:round;stroke-dasharray:none;stroke-opacity:1" transform="translate(1.605 -1.99)"/><path fill="#F41240" d="M162.324 45.568c5.52 0 9.998-4.477 9.998-10s-4.478-10-9.998-10c-5.524 0-10.002 4.477-10.002 10s4.478 10 10.002 10z" style="display:inline;fill:#000000;fill-opacity:1;stroke:none;stroke-width:10.6667;stroke-linecap:round;stroke-linejoin:round;stroke-dasharray:none;stroke-opacity:1" transform="translate(1.605 -1.99)"/></svg>',

            ]
        );
        return $button;
    }
}
